definition module StdProcessDef


//	********************************************************************************
//	Clean Standard Object I/O library, version 1.0.1
//	
//	StdProcessDef contains the types to define interactive processes.
//	********************************************************************************


import	StdIOCommon
from	iostate	import PSt, IOSt


::  ProcessGroup pdef
	=	E..p:ProcessGroup p (pdef p)
::  NDIProcess      p									 // DocumentInterface: NDI
	=	E..l:	NDIProcess	l
							(ProcessInit      (PSt l p))
							[ProcessAttribute (PSt l p)]
::  SDIProcess wdef p									 // DocumentInterface: SDI
	=	E..l ls:SDIProcess	l ls
							(wdef          ls (PSt l p))
							(ProcessInit      (PSt l p))
							[ProcessAttribute (PSt l p)]
::  MDIProcess      p									 // DocumentInterface: MDI
	=	E..l:	MDIProcess	l
							(ProcessInit      (PSt l p))
							[ProcessAttribute (PSt l p)]

/*	NDIProcesses can't open windows and menus.
	SDIProcesses can't open windows, except for their argument window. 
	MDIProcesses can open an arbitrary number of device instances. 
*/

::	ProcessInit ps
	:==	[IdFun ps]
